% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundary.R
\name{warp_boundary}
\alias{warp_boundary}
\title{Locate period boundaries for a date vector}
\usage{
warp_boundary(x, period, every = 1L, origin = NULL)
}
\arguments{
\item{x}{\verb{[Date / POSIXct / POSIXlt]}

A date time vector.}

\item{period}{\verb{[character(1)]}

A string defining the period to group by. Valid inputs can be roughly
broken into:
\itemize{
\item \code{"year"}, \code{"quarter"}, \code{"month"}, \code{"week"}, \code{"day"}
\item \code{"hour"}, \code{"minute"}, \code{"second"}, \code{"millisecond"}
\item \code{"yweek"}, \code{"mweek"}
\item \code{"yday"}, \code{"mday"}
}}

\item{every}{\verb{[positive integer(1)]}

The number of periods to group together.

For example, if the period was set to \code{"year"} with an every value of \code{2},
then the years 1970 and 1971 would be placed in the same group.}

\item{origin}{\verb{[Date(1) / POSIXct(1) / POSIXlt(1) / NULL]}

The reference date time value. The default when left as \code{NULL} is the
epoch time of \verb{1970-01-01 00:00:00}, \emph{in the time zone of the index}.

This is generally used to define the anchor time to count from, which is
relevant when the every value is \verb{> 1}.}
}
\value{
A two column data frame with the columns \code{start} and \code{stop}. Both are
double vectors representing boundaries of the date time groups.
}
\description{
\code{warp_boundary()} detects a change in time period along \code{x}, for example,
rolling from one month to the next. It returns the start and stop positions
for each contiguous period chunk in \code{x}.
}
\details{
The stop positions are just the \code{\link[=warp_change]{warp_change()}} values, and the start
positions are computed from these.
}
\examples{
x <- as.Date("1970-01-01") + -4:5
x

# Boundaries by month
warp_boundary(x, "month")

# Bound by every 5 days, relative to "1970-01-01"
# Creates boundaries of:
# [1969-12-27, 1970-01-01)
# [1970-01-01, 1970-01-06)
# [1970-01-06, 1970-01-11)
warp_boundary(x, "day", every = 5)

# Bound by every 5 days, relative to the smallest value in our vector
origin <- min(x)
origin

# Creates boundaries of:
# [1969-12-28, 1970-01-02)
# [1970-01-02, 1970-01-07)
warp_boundary(x, "day", every = 5, origin = origin)
}
