\name{spp.var}
\alias{spp.var}
\alias{Hypergeometric}
\title{Variance of a Seasonal Persistent Process}
\description{
  Computes the variance of a seasonal persistent (SP) process using a
  hypergeometric series expansion.
}
\usage{
spp.var(d, fG, sigma2 = 1)
Hypergeometric(a, b, c, z)
}
\arguments{
  \item{d}{Fractional difference parameter.}
  \item{fG}{Gegenbauer frequency.}
  \item{sigma2}{Innovations variance.}
  \item{a,b,c,z}{Parameters for the hypergeometric series.}
}
\value{
  The variance of an SP process.
}
\details{
  See Lapsa (1997).  The subroutine to compute a hypergeometric series
  was taken from \emph{Numerical Recipes in C}.
}
\references{
  Lapsa, P.M. (1997)
  Determination of Gegenbauer-type random process models.
  \emph{Signal Processing} \bold{63}, 73-90.

  Press, W.H., S.A. Teukolsky, W.T. Vetterling and B.P. Flannery (1992)
  \emph{Numerical Recipes in C}, 2nd edition,
  Cambridge University Press.
}
%\seealso{}
%\examples{}
\author{B. Whitcher}
\keyword{ts}
