% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb.R
\name{wb}
\alias{wb}
\title{Download Data from the World Bank API}
\usage{
wb(country = "all", indicator, startdate, enddate, mrv, return_wide = FALSE,
  gapfill, freq, cache, lang = c("en", "es", "fr", "ar", "zh"),
  removeNA = TRUE, POSIXct = FALSE, include_dec = FALSE,
  include_unit = FALSE, include_obsStatus = FALSE,
  include_lastUpdated = FALSE)
}
\arguments{
\item{country}{Character vector of country or region codes. Default value is special code of \code{all}.
Other permissible values are codes in the following fields from the \code{\link{wb_cachelist}} \code{country}
data frame. \code{iso3c}, \code{iso2c}, \code{regionID}, \code{adminID}, and \code{incomeID}.
Additional special values include \code{aggregates}, which returns only aggregates, and \code{countries_only},
which returns all countries without aggregates.}

\item{indicator}{Character vector of indicator codes. These codes correspond to the \code{indicatorID} column
from the \code{indicator} data frame of \code{\link{wbcache}} or \code{\link{wb_cachelist}}, or
the result of \code{\link{wbindicators}}}

\item{startdate}{Numeric or character. If numeric it must be in \%Y form (i.e. four digit year).
For data at the subannual granularity the API supports a format as follows: for monthly data, "2016M01"
and for quarterly data, "2016Q1". This also accepts a special value of "YTD", useful for more frequently
updated subannual indicators.}

\item{enddate}{Numeric or character. If numeric it must be in \%Y form (i.e. four digit year).
For data at the subannual granularity the API supports a format as follows: for monthly data, "2016M01"
and for quarterly data, "2016Q1".}

\item{mrv}{Numeric. The number of Most Recent Values to return. A replacement of \code{startdate} and \code{enddate},
this number represents the number of observations you which to return starting from the most recent date of collection.
Useful in conjuction with \code{freq}}

\item{return_wide}{Logical. If \code{TRUE} data is returned in a wide format instead of long, with a column named for each
\code{indicatorID}. To necessitate this transformation, the \code{indicator} column, that provides the human readable description
is dropped. This field is available through from the \code{indicator} data frame of \code{\link{wbcache}} or \code{\link{wb_cachelist}},
or the result of \code{\link{wbindicators}}. Default is \code{FALSE}}

\item{gapfill}{Logical. Works with \code{mrv}. If \code{TRUE} fills values, if not available, by back tracking to the
next available period (max number of periods back tracked will be limited by \code{mrv} number)}

\item{freq}{Character String. For fetching quarterly ("Q"), monthly("M") or yearly ("Y") values.
Currently works along with \code{mrv}. Useful for querying high frequency data.}

\item{cache}{List of data frames returned from \code{\link{wbcache}}. If omitted,
\code{\link{wb_cachelist}} is used}

\item{lang}{Language in which to return the results. If \code{lang} is unspecified,
english is the default.}

\item{removeNA}{if \code{TRUE}, remove any blank or \code{NA} observations that are returned.
if \code{FALSE}, no blank or \code{NA} values are removed from the return.}

\item{POSIXct}{if \code{TRUE}, additonal columns \code{date_ct} and \code{granularity} are added.
\code{date_ct} converts the default date into a \code{\link[base]{POSIXct}}. \code{granularity}
denotes the time resolution that the date represents.  Useful for subannual data and mixing subannual
with annual data. If \code{FALSE}, these fields are not added.}

\item{include_dec}{if \code{TRUE}, the column \code{decimal} is not removed from the return. if \code{FALSE},
this column is removed}

\item{include_unit}{if \code{TRUE}, the column \code{unit} is not removed from the return. if \code{FALSE},
this column is removed}

\item{include_obsStatus}{if \code{TRUE}, the column \code{obsStatus} is not removed from the return. if \code{FALSE},
this column is removed}

\item{include_lastUpdated}{if \code{TRUE}, the column \code{lastUpdated} is not removed from the return. if \code{FALSE},
this column is removed. If \code{TRUE} and \code{POSIXct = TRUE} then column will be of class \code{\link[base]{Date}}}
}
\value{
Data frame with all available requested data.
}
\description{
This function downloads the requested information using the World Bank API
}
\note{
Not all data returns have support for langauges other than english. If the specific return
 does not support your requested language by default it will return \code{NA}. For an enumeration of
 supported languages by data source please see \code{\link{wbdatacatalog}}.
 The options for \code{lang} are:
 \itemize{
 \item \code{en}: English
 \item \code{es}: Spanish
 \item \code{fr}: French
 \item \code{ar}: Arabic
 \item \code{zh}: Mandarin
 }
 The \code{POSIXct} parameter requries the use of \code{\link[lubridate]{lubridate}} (>= 1.5.0). All dates
 are rounded down to the floor. For example a value for the year 2016 would have a \code{POSIXct} date of
 \code{2016-01-01}. If this package is not available and the \code{POSIXct} parameter is set to \code{TRUE},
 the parameter is ignored and a \code{warning} is produced.

 The \code{include_dec}, \code{include_unit}, and \code{include_obsStatus} are defaulted to \code{FALSE}
 because as of writing, all returns have a value of \code{0}, \code{NA}, and \code{NA}, respectively.
 These columns might be used in the future by the API, therefore the option to include the column is available.

 The \code{include_lastUpdated} is defaulted to \code{FALSE} as well to limit the

 If there is no data available that matches the request parameters, an empty data frame is returned along with a
 \code{warning}. This design is for easy aggregation of multiple calls.
}
\examples{
 # GDP at market prices (current US$) for all available countries and regions
 \donttest{wb(indicator = "NY.GDP.MKTP.CD", startdate = 2000, enddate = 2016)}

 # GDP and Population in long format for the most recent 20 observations
 \donttest{wb(indicator = c("SP.POP.TOTL","NY.GDP.MKTP.CD"), mrv = 20)}

 # GDP and Population in wide format for the most recent 20 observations
 \donttest{wb(indicator = c("SP.POP.TOTL","NY.GDP.MKTP.CD"), mrv = 20, return_wide = TRUE)}

 # query using regionID or incomeID
 # High Income Countries and Sub-Saharan Africa (all income levels)
 wb(country = c("HIC", "SSF"), indicator = "NY.GDP.MKTP.CD", startdate = 1985, enddate = 1985)

 # if you do not know when the latest time an indicator is avaiable mrv can help
 wb(country = c("IN"), indicator = 'EG.ELC.ACCS.ZS', mrv = 1)

 # increase the mrv value to increase the number of maximum number of returns
 wb(country = c("IN"), indicator = 'EG.ELC.ACCS.ZS', mrv = 35)

 # GDP at market prices (current US$) for only available countries
 \donttest{wb(country = "countries_only", indicator = "NY.GDP.MKTP.CD", startdate = 2000, enddate = 2016)}

 # GDP at market prices (current US$) for only available aggregate regions
 \donttest{wb(country = "aggregates", indicator = "NY.GDP.MKTP.CD", startdate = 2000, enddate = 2016)}

 # if you want to "fill-in" the values in between actual observations use gapfill = TRUE
 # this highlights a very important difference.
 # all other parameters are the same as above, except gapfill = TRUE
 # and the results are very different
 wb(country = c("IN"), indicator = 'EG.ELC.ACCS.ZS', mrv = 35, gapfill = TRUE)

 # if you want the most recent values within a certain time frame
 wb(country = c("US"), indicator = 'SI.DST.04TH.20', startdate = 1970, enddate = 2000, mrv = 2)

 # without the freq parameter the deafult temporal granularity search is yearly
 # should return the 12 most recent years of data
 wb(country = c("CHN", "IND"), indicator = "DPANUSSPF", mrv = 12)

 # if another frequency is available for that indicator it can be accessed using the freq parameter
 # should return the 12 most recent months of data
 wb(country = c("CHN", "IND"), indicator = "DPANUSSPF", mrv = 12, freq = "M")
}
