% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_for_failed_request.R
\name{check_for_failed_request}
\alias{check_for_failed_request}
\title{Check for failed API request}
\usage{
check_for_failed_request(body)
}
\arguments{
\item{body}{The response body from the API request, typically in JSON format,
which may contain an error message if the request failed.}
}
\value{
This function does not return a value. If the request contains an error message,
it raises an error and halts execution.
}
\description{
This function checks the response body from an API request to determine if the request failed.
If the request contains an error message, the function will raise an error with a detailed
message including the message ID and value.
}
\details{
This function inspects the first element of the response body to check for
an error message. If a message is found, the function retrieves the \code{id}, \code{key}, and
\code{value} fields from the error message and constructs an error using \code{cli::cli_abort()}.
The function is intended to ensure failed API requests are handled gracefully.
}
