% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gecko.R
\name{gecko}
\alias{gecko}
\title{Start gecko driver}
\usage{
gecko(
  port = 4567L,
  version = "latest",
  check = TRUE,
  loglevel = c("info", "fatal", "error", "warn", "config", "debug", "trace"),
  verbose = TRUE,
  retcommand = FALSE,
  ...
)
}
\arguments{
\item{port}{Port to run on}

\item{version}{what version of geckodriver to run. Default = "latest"
which runs the most recent version. To see other version currently
sourced run binman::list_versions("geckodriver")}

\item{check}{If TRUE check the versions of geckodriver available. If
new versions are available they will be downloaded.}

\item{loglevel}{Set Gecko log level [values: fatal, error,
warn, info, config, debug, trace]}

\item{verbose}{If TRUE, include status messages (if any)}

\item{retcommand}{If TRUE return only the command that would be passed
to \code{\link[processx]{process}}}

\item{...}{pass additional options to the driver}
}
\value{
Returns a list with named elements \code{process}, \code{output},
    \code{error}, \code{stop}, and \code{log}.
    \code{process} is the object from calling \code{\link[processx]{process}}.
    \code{output} and \code{error} are the functions reading the latest
    messages from "stdout" and "stderr" since the last call whereas \code{log}
    is the function that reads all messages.
    Lastly, \code{stop} call the \code{kill} method in
    \code{\link[processx]{process}} to the kill the \code{process}.
}
\description{
Start gecko driver
}
\examples{
\dontrun{
gDrv <- gecko()
gDrv$output()
gDrv$stop()
}
}
