% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{list_funs}
\alias{list_funs}
\alias{list_sections}
\alias{list_services}
\alias{list_layers}
\alias{list_urls}
\title{List available sections, services, layers, and URLs in the WDNR GIS REST API}
\usage{
list_sections()

list_services(sections = NULL, pull = TRUE)

list_layers(sections = NULL, services = NULL, pull = TRUE)

list_urls(layers = NULL, sections = NULL, services = NULL, pull = TRUE)
}
\arguments{
\item{sections}{A character vector of available sections to subset by}

\item{pull}{Logical. Pull unique values (TRUE, default) or show the matching
rows in the service_urls data.frame}

\item{services}{A character vector of available services to subset by}

\item{layers}{A character vector of available layers to subset by}
}
\value{
A vector of matching sections, services, layers, or URLs depending
on the function called
}
\description{
These functions can take sections, services, and layers specified as
character strings and return either the section, service, layer or url as
available in the WDNR GIS REST API
}
\examples{
list_sections()
list_services(sections = "WT_TMDL")
list_layers(services = match_services("Invasive"))
list_urls(sections = match_sections("WT"),
          services = match_services("inland"))
}
