% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_TL_laplacian.R
\name{compute_TL_laplacian}
\alias{compute_TL_laplacian}
\title{Compute topological ordering}
\usage{
compute_TL_laplacian(G)
}
\arguments{
\item{G}{The metaweb, it has to be an igraph object}
}
\value{
The trophic level of each node of G. By ordering species according to their trophic level, we obtain one topological ordering of the graph.
}
\description{
Method to compute trophic levels from an igraph object G with the method described in MacKay et al 2020.
}
\examples{
data(G)
compute_TL_laplacian(G)
}
\references{
MacKay, R. S., Johnson, S., & Sansom, B. (2020). How directed is a directed network?. Royal Society open science, 7(9), 201138.
}
\author{
Giovanni Poggiato
}
