% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_leaders.R
\name{wnba_leagueleaders}
\alias{wnba_leagueleaders}
\title{\strong{Get WNBA Stats API League Leaders}}
\usage{
wnba_leagueleaders(
  active_flag = "",
  league_id = "10",
  per_mode = "Totals",
  scope = "S",
  season = most_recent_wnba_season() - 1,
  season_type = "Regular Season",
  stat_category = "PTS",
  ...
)
}
\arguments{
\item{active_flag}{Active Flag}

\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{per_mode}{Per Mode - Totals, PerGame, Per48}

\item{scope}{Scope - RS, S, Rookies}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs}

\item{stat_category}{Stat Category: PTS, REB, AST, FG_PCT, FT_PCT, FG3_PCT, STL, BLK}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: LeagueLeaders

\strong{LeagueLeaders}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   RANK \tab character \cr
   PLAYER \tab character \cr
   TEAM_ID \tab character \cr
   TEAM \tab character \cr
   GP \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TOV \tab character \cr
   PF \tab character \cr
   PTS \tab character \cr
   EFF \tab character \cr
   AST_TOV \tab character \cr
   STL_TOV \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API League Leaders}

\strong{Get WNBA Stats API League Leaders}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ wnba_leagueleaders(league_id = '10')
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Leaders Functions: 
\code{\link{wnba_alltimeleadersgrids}()},
\code{\link{wnba_assistleaders}()},
\code{\link{wnba_assisttracker}()},
\code{\link{wnba_homepageleaders}()},
\code{\link{wnba_homepagev2}()},
\code{\link{wnba_leaderstiles}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Leaders Functions}
