% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdists.R
\name{summary-densities}
\alias{summary-densities}
\alias{summary.Wdensities}
\alias{mean.Wdensities}
\alias{auroc.crude}
\alias{auroc.model}
\alias{lambda.crude}
\alias{lambda.model}
\title{Summary evaluation of predictive performance}
\usage{
\method{summary}{Wdensities}(object, ...)

\method{mean}{Wdensities}(x, ...)

auroc.crude(densities)

auroc.model(densities)

lambda.crude(densities)

lambda.model(densities)
}
\arguments{
\item{object, x, densities}{Densities object produced by
\code{\link{Wdensities}}.}

\item{\dots}{Further arguments passed to or from other methods. These are
currently ignored.}
}
\value{
\code{summary} returns a data frame that reports the number of cases and
controls, the test log-likelihood, the crude and model-based C-statistic
and expected weight of evidence Lambda.

\code{mean} returns a numeric vector listing the mean densities of the weight
of evidence in controls and in cases.

\code{auroc.crude} and \code{auroc.model} return the area under the ROC curve
according to the crude and the model-based densities of weight of evidence,
respectively.

\code{lambda.crude} and \code{lambda.model} return the expected weight of
evidence (expected information for discrimination) in bits from the crude
and the model-based densities, respectively.
}
\description{
Summary evaluation of predictive performance
}
\examples{
data(cleveland)
densities <- with(cleveland, Wdensities(y, posterior.p, prior.p))

summary(densities)
mean(densities)
auroc.model(densities)
lambda.model(densities)

}
