% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whirl-options.R
\name{whirl-options}
\alias{whirl-options}
\title{Options for whirl}
\description{
\subsection{verbosity_level}{

Verbosity level for functions in whirl.
See \link[zephyr:verbosity_level]{zephyr::verbosity_level} for details.
\itemize{
\item Default: \code{NA_character_}
\item Option: \code{whirl.verbosity_level}
\item Environment: \code{R_WHIRL_VERBOSITY_LEVEL}
}
}

\subsection{out_formats}{

Which log format(s) to produce. Possibilities are \code{html},
\code{json}, and markdown formats: \code{gfm}, \code{commonmark}, and \code{markua}.
\itemize{
\item Default: \code{"html"}
\item Option: \code{whirl.out_formats}
\item Environment: \code{R_WHIRL_OUT_FORMATS}
}
}

\subsection{track_files}{

Should files read and written be tracked?
Currently only supported on Linux.
\itemize{
\item Default: \code{FALSE}
\item Option: \code{whirl.track_files}
\item Environment: \code{R_WHIRL_TRACK_FILES}
}
}

\subsection{check_renv}{

Should the projects renv status be checked?
\itemize{
\item Default: \code{FALSE}
\item Option: \code{whirl.check_renv}
\item Environment: \code{R_WHIRL_CHECK_RENV}
}
}

\subsection{track_files_discards}{

List of file naming patterns not be tracked when track_files = TRUE
\itemize{
\item Default: \code{c("^/lib", "^/etc", "^/lib64", "^/usr", "^/var", "^/opt", "^/sys", "^/proc", "^/tmp", "^/null", "^/urandom", "^/.cache")}
\item Option: \code{whirl.track_files_discards}
\item Environment: \code{R_WHIRL_TRACK_FILES_DISCARDS}
}
}

\subsection{track_files_keep}{

List of file naming patterns always to be tracked when
track_files = TRUE
\itemize{
\item Default: \code{NULL}
\item Option: \code{whirl.track_files_keep}
\item Environment: \code{R_WHIRL_TRACK_FILES_KEEP}
}
}

\subsection{approved_pkgs_folder}{

Approved folder library packages
\itemize{
\item Default: \code{NULL}
\item Option: \code{whirl.approved_pkgs_folder}
\item Environment: \code{R_WHIRL_APPROVED_PKGS_FOLDER}
}
}

\subsection{approved_pkgs_url}{

Approved URL library packages
\itemize{
\item Default: \code{NULL}
\item Option: \code{whirl.approved_pkgs_url}
\item Environment: \code{R_WHIRL_APPROVED_PKGS_URL}
}
}

\subsection{n_workers}{

Number of simultaneous workers used in the run function.
A maximum of 128 workers is allowed.
\itemize{
\item Default: \code{1}
\item Option: \code{whirl.n_workers}
\item Environment: \code{R_WHIRL_N_WORKERS}
}
}

\subsection{log_dir}{

The output directory of the log files. Default is the folder of
the executed script. log_dir can be a path as a character or it can be a
function that takes the script path as input and returns the log directory.
For more information see the examples of \code{run()} or \code{vignette('whirl')}.
\itemize{
\item Default: \code{function (x)  dirname(x)}
\item Option: \code{whirl.log_dir}
\item Environment: \code{R_WHIRL_LOG_DIR}
}
}

\subsection{execute_dir}{

The working directory of the process executing each script.
Default us to execute R files from the working directory when calling \code{run()}
and all other functions from the directory of the script. To change provide
a character path (used for all scripts) or a function that takes the script
as input and returns the execution directory.
\itemize{
\item Default: \code{NULL}
\item Option: \code{whirl.execute_dir}
\item Environment: \code{R_WHIRL_EXECUTE_DIR}
}
}

\subsection{wait_timeout}{

Timeout for waiting for the R process from callr::r_session to
start, in milliseconds.
\itemize{
\item Default: \code{9000}
\item Option: \code{whirl.wait_timeout}
\item Environment: \code{R_WHIRL_WAIT_TIMEOUT}
}
}
}
