% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_gaussian_scale_space}
\alias{wbt_gaussian_scale_space}
\title{Gaussian scale space}
\usage{
wbt_gaussian_scale_space(
  dem,
  output,
  output_zscore,
  output_scale,
  points = NULL,
  sigma = 0.5,
  step = 0.5,
  num_steps = 10,
  lsp = "Slope",
  z_factor = NULL,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Name of the input DEM raster file.}

\item{output}{Name of the output land-surface parameter raster file.}

\item{output_zscore}{Name of the output z-score raster file.}

\item{output_scale}{Name of the output scale raster file.}

\item{points}{Name of the input vector points shapefile.}

\item{sigma}{Initial sigma value (cells).}

\item{step}{Step size as any positive non-zero integer.}

\item{num_steps}{Number of steps.}

\item{lsp}{Output land-surface parameter; one of 'AnisotropyLTP', 'Aspect', 'DiffMeanElev', 'Eastness', 'Elevation', 'Hillshade', 'MeanCurvature', 'Northness', 'PlanCurvature', 'ProfileCurvature', 'Ruggedness', 'Slope', 'TanCurvature', 'TotalCurvature'.}

\item{z_factor}{Optional multiplier for when the vertical and horizontal units are not the same.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Uses the fast Gaussian approximation algorithm to produce scaled land-surface parameter measurements from an input DEM.
}
\keyword{GeomorphometricAnalysis}
