% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request-gracefully.R
\name{gracefully}
\alias{gracefully}
\title{Gracefully request a resource from Wikipedia}
\usage{
gracefully(request_object, request_method)
}
\arguments{
\item{request_object}{A \code{httr2_request} object describing a query to a
Wikimedia Action API}

\item{request_method}{The desired function for performing the request,
typically one of those in \link{get_query_results}}
}
\value{
The output of \code{request_method} called on \code{request_object}, if the
request was successful. Otherwise a \code{httr2_response} object with details
of the failed request.
}
\description{
The main purpose of this function is to enable examples using live resources
in the documentation. Examples must not throw errors, according to CRAN
policy. If you wrap a requesting method in \code{gracefully}, then any
errors of type \code{httr2_http} will be caught and no error will be thrown.
}
\examples{
\dontshow{if (rlang::is_installed("webfakes")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# This fails without throwing an error
req <- httr2::request(httr2::example_url()) |>
  httr2::req_url_path("/status/404")

resp <- gracefully(req, httr2::req_perform)

print(resp)

# This request succeeds
req <- httr2::request(httr2::example_url())

resp <- gracefully(req, httr2::req_perform)

print(resp)
\dontshow{\}) # examplesIf}
}
