% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_back.R
\name{winch_trace_back}
\alias{winch_trace_back}
\title{Native stack trace}
\usage{
winch_trace_back()
}
\value{
A data frame with the columns:
\itemize{
\item \code{func}: function name
\item \code{ip}: instruction pointer
\item \code{pathname}: path to shared library
}
}
\description{
This function returns the native stack trace as a data frame.
Each native stack frame corresponds to one row in the returned data frame.
Deep function calls come first, the last row corresponds to the
running process's entry point.
}
\details{
On Windows, call \code{\link[=winch_init_library]{winch_init_library()}} to return function names
for a specific package.
}
\examples{
winch_trace_back()

foo <- function() {
  winch_call(bar)
}

bar <- function() {
  winch_trace_back()
}

foo()
}
\seealso{
\code{\link[=sys.calls]{sys.calls()}} for the R equivalent.
}
