#' @name turbineSpatial
#'
#' @title Data sets of spatial area searched at a wind farm
#'
#' @description List containing two spatial data frames
#'
#' @usage data(turbineSpatial)
#'
#' @details
#' A list of data frames, with two elements named \code{turbinePlots} and \code{turbinePoints}. These are fictious data for example purposes only.
#'
#'
#' @format The \code{turbinePlots} element is a spatial data frame with:
#' \describe{
#'   \item{\code{turbName}}{The name of the turbine for the search plot.}
#' \item{\code{plotType}{The type of the search plot around the turbine.}
#' }
#'
#' @format The \code{turbinePoints} element is a spatial data frame with:
#' \describe{
#'   \item{\code{turbName}}{The name of the turbine for the search plot.}
#' }
#'


"turbineSpatial"
