% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_gd.R
\name{mask_gd}
\alias{mask_gd}
\title{Mask moving window maps}
\usage{
mask_gd(x, y, minval = NULL, maxval = NULL)
}
\arguments{
\item{x}{Raster object to mask}

\item{y}{Raster object or Spatial object to use as mask}

\item{minval}{if y is a Raster object, value of y below which to mask}

\item{maxval}{if y is a Raster object, value of y above which to mask}
}
\value{
RasterLayer
}
\description{
Mask genetic diversity layer produced by \link[wingen]{window_gd} or \link[wingen]{krig_gd}
}
\examples{
data("mini_lyr")
mpi <- mask_gd(mini_lyr, mini_lyr, minval = 0.01)

}
