% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{wkb_format}
\alias{wkb_format}
\alias{wkt_format}
\alias{wksxp_format}
\title{Format well-known geometry for printing}
\usage{
wkb_format(wkb, max_coords = 3)

wkt_format(wkt, max_coords = 3)

wksxp_format(wksxp, max_coords = 3)
}
\arguments{
\item{wkb}{A \code{list()} of \code{\link[=raw]{raw()}} vectors, such as that
returned by \code{\link[sf:st_as_binary]{sf::st_as_binary()}}.}

\item{max_coords}{The maximum number of coordinates to include
in the output.}

\item{wkt}{A character vector containing well-known text.}

\item{wksxp}{A \code{list()} of classed objects}
}
\value{
A character vector of abbreviated well-known text.
}
\description{
Provides an abbreviated version of the well-known text
representation of a geometry. This returns a constant
number of coordinates for each geometry, so is safe to
use for geometry vectors with many (potentially large)
features.
}
\examples{
wkt_format("MULTIPOLYGON (((0 0, 10 0, 0 10, 0 0)))")
wkb_format(
  wkt_translate_wkb(
    "MULTIPOLYGON (((0 0, 10 0, 0 10, 0 0)))"
  )
)

}
