% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worcs_project.R
\name{add_preregistration}
\alias{add_preregistration}
\title{Add Rmarkdown preregistration}
\usage{
add_preregistration(
  worcs_directory = ".",
  preregistration = "cos_prereg",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{worcs_directory}{Character, indicating the directory
in which to create the manuscript files. Default: '.', which points to the
current working directory.}

\item{preregistration}{Character, indicating what template to use for the
preregistration. Default: \code{"cos_prereg"}; use \code{"None"} to omit a
preregistration. See Details for other available choices.}

\item{verbose}{Logical. Whether or not to print messages to the console
during project creation. Default: TRUE}

\item{...}{Additional arguments passed to and from functions.}
}
\value{
No return value. This function is called for its side effects.
}
\description{
Adds an Rmarkdown preregistration template to a 'worcs' project.
}
\details{
Available choices include the templates from the
\code{\link[prereg:prereg]{prereg}} package, and several unique templates
included with \code{worcs}:
\describe{
\item{\code{'PSS'}}{Preregistration and Sharing Software (Krypotos,
Klugkist, Mertens, & Engelhard, 2019)}
\item{\code{'Secondary'}}{Preregistration for secondary analyses (Mertens &
Krypotos, 2019)}
\item{\code{'aspredicted_prereg'}}{aspredicted template from the \code{prereg} package}
\item{\code{'brandt_prereg'}}{brandt template from the \code{prereg} package}
\item{\code{'cos_prereg'}}{cos template from the \code{prereg} package}
\item{\code{'fmri_prereg'}}{fmri template from the \code{prereg} package}
\item{\code{'prp_quant_prereg'}}{prp_quant template from the \code{prereg} package}
\item{\code{'psyquant_prereg'}}{psyquant template from the \code{prereg} package}
\item{\code{'rr_prereg'}}{rr template from the \code{prereg} package}
\item{\code{'vantveer_prereg'}}{vantveer template from the \code{prereg} package}
}
}
\examples{
the_test <- "worcs_prereg"
old_wd <- getwd()
dir.create(file.path(tempdir(), the_test))
file.create(file.path(tempdir(), the_test, ".worcs"))
add_preregistration(file.path(tempdir(), the_test),
                    preregistration = "cos_prereg")
setwd(old_wd)
unlink(file.path(tempdir(), the_test))
}
