% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{Base}
\alias{Base}
\title{Base class for all other classes}
\description{
Provides a basic structure for processing text files. Also provides methods
for reading and writing files and objects.
}
\details{
It provides pre-processing, processing and post-processing methods, which
need to be overridden by derived classes.

The pre-processing function is called before reading a file. The process
function is called for processing a given number of lines. The post
processing function is called on the processed data.

Also provides methods for reading and writing text files and R objects. All
class methods are private.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Base$new()}}
\item \href{#method-clone}{\code{Base$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
It initializes the current object. It is used to set the file name
and verbose options.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Base$new(fn = NULL, lc = 100, ve = 2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{The path to the file to clean.}

\item{\code{lc}}{The number of lines to read and clean at a time.}

\item{\code{ve}}{The level of detail in the information messages.
Reads the given file one line at a time. It runs the given
pre-processing function before reading the file. It runs the given}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Base$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
