% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract_workflow_set_result}
\alias{extract_workflow_set_result}
\alias{extract_workflow.workflow_set}
\alias{extract_spec_parsnip.workflow_set}
\alias{extract_recipe.workflow_set}
\alias{extract_fit_parsnip.workflow_set}
\alias{extract_fit_engine.workflow_set}
\alias{extract_mold.workflow_set}
\alias{extract_preprocessor.workflow_set}
\alias{extract_parameter_set_dials.workflow_set}
\alias{extract_parameter_dials.workflow_set}
\title{Extract elements of workflow sets}
\usage{
extract_workflow_set_result(x, id, ...)

\method{extract_workflow}{workflow_set}(x, id, ...)

\method{extract_spec_parsnip}{workflow_set}(x, id, ...)

\method{extract_recipe}{workflow_set}(x, id, ..., estimated = TRUE)

\method{extract_fit_parsnip}{workflow_set}(x, id, ...)

\method{extract_fit_engine}{workflow_set}(x, id, ...)

\method{extract_mold}{workflow_set}(x, id, ...)

\method{extract_preprocessor}{workflow_set}(x, id, ...)

\method{extract_parameter_set_dials}{workflow_set}(x, id, ...)

\method{extract_parameter_dials}{workflow_set}(x, id, parameter, ...)
}
\arguments{
\item{x}{A workflow set outputted by \code{\link[=workflow_set]{workflow_set()}} or \code{\link[=workflow_map]{workflow_map()}}.}

\item{id}{A single character string for a workflow ID.}

\item{...}{Other options (not currently used).}

\item{estimated}{A logical for whether the original (unfit) recipe or the
fitted recipe should be returned.}

\item{parameter}{A single string for the parameter ID.}
}
\value{
The extracted value from the object, \code{x}, as described in the
description section.
}
\description{
These functions extract various elements from a workflow set object. If they
do not exist yet, an error is thrown.
\itemize{
\item \code{extract_preprocessor()} returns the formula, recipe, or variable
expressions used for preprocessing.
\item \code{extract_spec_parsnip()} returns the parsnip model specification.
\item \code{extract_fit_parsnip()} returns the parsnip model fit object.
\item \code{extract_fit_engine()} returns the engine specific fit embedded within
a parsnip model fit. For example, when using \code{\link[parsnip:linear_reg]{parsnip::linear_reg()}}
with the \code{"lm"} engine, this returns the underlying \code{lm} object.
\item \code{extract_mold()} returns the preprocessed "mold" object returned
from \code{\link[hardhat:mold]{hardhat::mold()}}. It contains information about the preprocessing,
including either the prepped recipe, the formula terms object, or
variable selectors.
\item \code{extract_recipe()} returns the recipe. The \code{estimated} argument specifies
whether the fitted or original recipe is returned.
\item \code{extract_workflow_set_result()} returns the results of \code{\link[=workflow_map]{workflow_map()}}
for a particular workflow.
\item \code{extract_workflow()} returns the workflow object. The workflow will not
have been estimated.
\item \code{extract_parameter_set_dials()} returns the parameter set
\emph{that will be used to fit} the supplied row \code{id} of the workflow set.
Note that workflow sets reference a parameter set associated with the
\code{workflow} contained in the \code{info} column by default, but can be
fitted with a modified parameter set via the \code{\link[=option_add]{option_add()}} interface.
This extractor returns the latter, if it exists, and returns the former
if not, mirroring the process that \code{\link[=workflow_map]{workflow_map()}} follows to provide
tuning functions a parameter set.
\item \code{extract_parameter_dials()} returns the \code{parameters} object
\emph{that will be used to fit} the supplied tuning \code{parameter} in the supplied
row \code{id} of the workflow set. See the above notes in
\code{extract_parameter_set_dials()} on precedence.
}
}
\details{
These functions supersede the \verb{pull_*()} functions (e.g.,
\code{\link[=extract_workflow_set_result]{extract_workflow_set_result()}}).
}
\note{
The package supplies two pre-generated workflow sets, \code{two_class_set}
and \code{chi_features_set}, and associated sets of model fits
\code{two_class_res} and \code{chi_features_res}.

The \verb{two_class_*} objects are based on a binary classification problem
using the \code{two_class_dat} data from the modeldata package. The six
models utilize either a bare formula or a basic recipe utilizing
\code{recipes::step_YeoJohnson()} as a preprocessor, and a decision tree,
logistic regression, or MARS model specification. See \code{?two_class_set}
for source code.

The \verb{chi_features_*} objects are based on a regression problem using the
\code{Chicago} data from the modeldata package. Each of the three models
utilize a linear regression model specification, with three different
recipes of varying complexity. The objects are meant to approximate the
sequence of models built in Section 1.3 of Kuhn and Johnson (2019). See
\code{?chi_features_set} for source code.
}
\examples{
library(tune)

two_class_res

extract_workflow_set_result(two_class_res, "none_cart")

extract_workflow(two_class_res, "none_cart")
}
