% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filt3dimArr.R
\name{filt3dimArr}
\alias{filt3dimArr}
\title{Filter a three-dimensional array of numeric data}
\usage{
filt3dimArr(x, displCrit, filtCrit, filtVal, filtTy = ">")
}
\arguments{
\item{x}{array (3-dim) of numeric data}

\item{displCrit}{(character) column-name(s) to display}

\item{filtCrit}{(character, length=1) which column-name consider when filtering filter with 'filtVal' and 'filtTy'}

\item{filtVal}{(numeric) for testing inferior/superor/equal condition}

\item{filtTy}{(character) which type of testing to perform ('eq','inf','infeq','sup','supeq', ">", '<', '>=', "<=", "==")}
}
\value{
list of filtered matrixes (by 3rd dim)
}
\description{
Filtering of 3-dim array ('x') : filter column 'filtCrit' as 'larger as' (according to 'filtTy') 'filtVal' 
and extract/display all col matching 'displCrit'.
}
\examples{
arr1 <- array(1:24,dim=c(4,3,2),dimnames=list(c(LETTERS[1:4]),
  paste("col",1:3,sep=""),c("ch1","ch2")))
filt3dimArr(arr1,displCrit=c("col1","col2"),filtCrit="col2",filtVal=7)
}
