% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuseAnnotMatr.R
\name{fuseAnnotMatr}
\alias{fuseAnnotMatr}
\title{Fuse annotation matrix to initial matrix}
\usage{
fuseAnnotMatr(iniTab, annotTab, refIniT = "Uniprot",
  refAnnotT = "combName", addCol = c("ensembl_gene_id", "description",
  "geneName", "combName"), debug = TRUE, silent = FALSE,
  callFrom = NULL)
}
\arguments{
\item{iniTab}{(matrix), that may have lines with multiple (=repeated) key entries}

\item{annotTab}{(matrix) containing reference annotation}

\item{refIniT}{(character) type of reference (eg 'Uniprot')}

\item{refAnnotT}{(character) column name to use for reference-annotation}

\item{addCol}{(character) column-namess of 'annotTab' to use/extract (if no matches found, use all)}

\item{debug}{(logical) for bug-tracking: more/enhanced messages}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
combined matrix (elements not found in 'annotTab' are displayed as NA)
}
\description{
In a number of instances experimental measurements and additional information (annotation) are provided by separate objects (matrixes) as they may not be generated the same time.
The aim of this function is provide help when matching approprate lines for 2 sets of data (experimental measures in \code{iniTab} and annotation from \code{annotTab}) for fusing.  
\code{fuseAnnotMatr} adds suppelmental columns/annotation to an initial matrix \code{iniTab} : using column 'refIniT' as key (in \code{iniTab}) to compare with key 'refAnnotT' (from 'annotTab'). 
The columns to be added from \code{annotTab} must be chosen explicitely. 
Note: if  non-unique IDs in iniTab : runs slow (but save) due to use of loop for each unique ID.
}
\examples{
tab0 <- matrix(rep(letters[1:25],8),ncol=10)
tab1 <- cbind(Uniprot=paste(tab0[,1],tab0[,2]),col1=paste(tab0[,3],
  tab0[,4],tab0[,5]," ",tab0[,7],tab0[,6]))
tab2 <- cbind(combName=paste(tab0[,1],tab0[,2]),col2=paste(tab0[,8],tab0[,9],tab0[,10]))
fuseAnnotMatr(tab1,tab2[c(20:11,2:5),],refIni="Uniprot",refAnnotT="combName",addCol="col2")
fuseAnnotMatr(tab2[c(20:11,2:5),],tab1,refAnnotT="Uniprot",refIni="combName",addCol="col1")
}
\seealso{
\code{\link[base]{merge}}
}
