% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortByNRepeated.R
\name{sortByNRepeated}
\alias{sortByNRepeated}
\title{Make a list of common occurances sorted by number of repeats}
\usage{
sortByNRepeated(
  x,
  y = NULL,
  z = NULL,
  filterIntraRep = TRUE,
  silent = TRUE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(list, character or integer) main input, if list, arguments \code{y} and \code{z} will not be used}

\item{y}{(character or integer) supplemental vector to comare with \code{x}}

\item{z}{(character or integer) supplemental vector to comare with \code{x}}

\item{filterIntraRep}{(logical) allow making vectors \code{x}, \code{y} and \code{z} unique before comparing (defaults to \code{TRUE})}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a list sorted by number of occurances. The names of the list indicate the number of repeats.
}
\description{
The aim of this function is to count the number of occurances of words when comaring separate vectors (\code{x}, \code{y} and \code{z}) or from a list (given as \code{x})
and to give an output sorted by their frequency.
The output lists the various values/words by their frequency, the names of the resulting list-elements indicate number of times the values/words were found repeated.
}
\details{
In order to compare the frquency of values/words between separate vectors or vectors within a list, it is necessary that these have been made unique before calling this function or using \code{filterIntraRep=TRUE}. 

In case the input is given as list (in \code{x}), there is no restriction to the number of vectors to be compared. 
With very long lists, however, the computational effort incerases (like it does when using \code{table})
}
\examples{
sortByNRepeated(x=LETTERS[1:11], y=LETTERS[3:13], z=LETTERS[6:12])
sortByNRepeated(x=LETTERS[1:11], y=LETTERS[c(3:13,5:4)], z=LETTERS[6:12])

}
\seealso{
\code{\link[base]{table}},  \code{\link[wrMisc]{replicateStructure}}
}
