% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchSampToPairw.R
\name{matchSampToPairw}
\alias{matchSampToPairw}
\title{Match names to concatenated pairs of names}
\usage{
matchSampToPairw(grpNa, pairwNa, silent = FALSE, callFrom = NULL)
}
\arguments{
\item{grpNa}{(character) the names of the groups of replicates (ie conditions) used to test}

\item{pairwNa}{(character) the names of pairwise-testing (ie 'concatenated' \code{sampNa}}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of message(s) produced}
}
\value{
matrix of 2 columns with inidices of \code{sampNa} with \code{pairwNa} as rows
}
\description{
The column-names of multiple pairwise testing contain the names of the initial groups/conditions tested, plus there is a separator (eg '-' in \code{moderTestXgrp}).  
Thus function allows to map back which groups/conditions were used by returning the index of the respective groups used in pair-wise sets.
}
\details{
The names of initial groups/conditions (\code{grpNa}) will be tested for exact pattern matching either at beginning or at end of pair-wise names (\code{pairwNa}).
If there is no 'perfect' fit, the names concerned will not get matched.
Thus, it is not necessary to know what character(s) were used as separator when constructing the concatenated pair-wise names.
If some \code{grpNa} are not found in \code{pairwNa} this will be marked as NA.
}
\examples{
pairwNa1 <- c("abc-efg","abc-hij","efg-hij")
grpNa1 <- c("hij","abc","efg","klm")
matchSampToPairw(grpNa1, pairwNa1) 

pairwNa2 <- c("abc-efg","abc-hij","zz-zz","efg-hij")
matchSampToPairw(grpNa1, pairwNa2) 
}
\seealso{
(for running multiple pair-wise test) \code{\link{moderTestXgrp}}
}
