% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readPDExport.R
\name{readPDExport}
\alias{readPDExport}
\title{Read tabulated files imported from Thermo ProteomeDiscoverer}
\usage{
readPDExport(
  fileName,
  path = NULL,
  normalizeMeth = "median",
  annotCol = c("Accession", "Description", "Gene", "Sum.PEP.Score", "Coverage....",
    "X..Peptides", "X..PSMs", "X..Unique.Peptides", "X..AAs", "MW..kDa."),
  quantCol = "^S",
  refLi = NULL,
  separateAnnot = TRUE,
  plotGraph = TRUE,
  graphTit = "Proteome Discoverer",
  specPref = c(conta = "CON_|LYSC_CHICK", mainSpecies = "OS=Saccharomyces cerevisiae",
    spike = "HUMAN_UPS"),
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{fileName}{(character) name of file to be read (default 'proteinGroups.txt' as typically generated by MaxQuant in txt folder)}

\item{path}{(character) path of file to be read}

\item{normalizeMeth}{(character) normalization method (will be sent to  \code{\link[wrMisc]{normalizeThis}})}

\item{annotCol}{(character) column names to be read}

\item{quantCol}{(character or integer) exact col-names, or if length=1 content of \code{quantCol} will be used as pattern to search among column-names for $quant using \code{grep}}

\item{refLi}{(integer) custom decide which line of data is main species}

\item{separateAnnot}{(logical) if \code{TRUE} output will be organized as list with \code{$annot}, \code{$abund} for initial/raw abundance values and \code{$quant} with final normalized quantitations}

\item{plotGraph}{(logical) optional plot of type vioplot of initial and normalized data (using \code{normalizeMeth}); if integer, it will be passed to \code{layout} when plotting}

\item{graphTit}{(character) custom title to plot}

\item{specPref}{(character) define characteristic text for recognizing the 3 (main) groups of species (contaminants,mainSpecies,spike)}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
list with \code{$annot}, \code{$raw} for initial/raw abundance values and \code{$quant} with final normalized quantitations, or returns data.frame with annot and quant if \code{separateAnnot=FALSE}
}
\description{
Quantification results form \href{https://www.thermofisher.com/order/catalog/product/OPTON-30812}{Thermo ProteomeDiscoverer} 
exported as tabulated text can be imported and relevant information extracted. 
The final output is a list containing 3 elements: \code{$annot}, \code{$raw} and optional \code{$quant}, or returns data.frame with entire content of file if \code{separateAnnot=FALSE}.
This function has been developed using MaxQuant version Thermo ProteomeDiscoverer2.4, the format of resulting file is typically well conserved.
}
\examples{
path1 <- system.file("extdata",package="wrProteo")
fiNa <- "exampleProtDiscov1.txt"
dataPD <- readPDExport(file=fiNa,path=path1)
summary(dataPD$quant)
matrixNAinspect(dataPD$quant,gr=gl(2,3)) 

}
\seealso{
\code{\link[utils]{read.table}}, \code{\link[wrMisc]{normalizeThis}}) , \code{\link{readProlineFile}}
}
