% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuseProteomicsProjects.R
\name{fuseProteomicsProjects}
\alias{fuseProteomicsProjects}
\title{Combine Multiple Proteomics Data-Sets}
\usage{
fuseProteomicsProjects(
  x,
  y,
  z = NULL,
  columnNa = "Accession",
  NA.rm = TRUE,
  listNa = c(quant = "quant", annot = "annot"),
  all = FALSE,
  textModif = NULL,
  shortNa = NULL,
  retProtLst = FALSE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(list) First Proteomics data-set}

\item{y}{(list) Second Proteomics data-set}

\item{z}{(list) optional third Proteomics data-set}

\item{columnNa}{(character) column names from annotation}

\item{NA.rm}{(logical) remove \code{NA}s}

\item{listNa}{(character) names of key list-elemnts from \code{x} to be treated; the first one is used as pattern for the format of quantitation data, 
,  the last one for the annotation data}

\item{all}{(logical) union of intersect or merge should be performed between x, y and z}

\item{textModif}{(character) Additional modifications to the identifiers from argument \code{columnNa}; 
so far intregrated: \code{rmPrecAA} for removing preceeding caps letters (amino-acids, eg [KR].AGVIFPVGR.[ML] => AGVIFPVGR) 
or \code{rmTerminalDigit} for removing terminal digits (charge-states)}

\item{shortNa}{(character) for appending to output-colnames}

\item{retProtLst}{(logical) return list-object similar to input, otherwise a matrix of fused/aligned quantitation data}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a list with the same number of list-elements as  \code{$x}, ie typically this contains :
  \code{$raw} (initial/raw abundance values), \code{$quant} with final normalized quantitations, 
  \code{$annot}, optionally \code{$counts} an array with number of peptides, \code{$quantNotes} or \code{$notes}
}
\description{
This function allows combining up to 3 separate data-sets previously imported using wrProteo.
}
\details{
Some quantification software way give some identifyers multiple times, ie as multiple lines (eg for different modifictions or charge states, etc).
In this case this function tries first to summarize all lines with identical identifyers (using the function \code{\link[wrMisc]{combineRedundLinesInList}}
which used by default the median value). 
Thus, it is very important to know your data and to understand when lines that appear with the same identifyers should/may be fused/summarized without 
doing damage to the later biological interpretation ! The user may specify for each dataset the colum out of the protein/peptide-annotation to use
via the argument \code{columnNa}. 
Then, this content will be matched as identical match, so when combining data from different software special care shoud be taken !

Please note, that (at this point) the data from different series/objects will be joined as they are, ie without any additional normalization.
It is up to the user to inspect the resulting data and to decide if and which type of normalization may be suitable !

Please do NOT try combining protein and peptide quntification data.
}
\examples{
path1 <- system.file("extdata", package="wrProteo")
dataMQ <- readMaxQuantFile(path1, specPref=NULL, normalizeMeth="median")
MCproFi1 <- "tinyMC.RData"
dataMC <- readMassChroQFile(path1, file=MCproFi1, plotGraph=FALSE)
dataFused <- fuseProteomicsProjects(dataMQ, dataMC)
dim(dataMQ$quant)
dim(dataMC$quant)
dim(dataFused$quant)
}
\seealso{
\code{\link[stats]{sd}}
}
