% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countPotModifAAs.R
\name{countPotModifAAs}
\alias{countPotModifAAs}
\title{Make table with counts of potential modification sites}
\usage{
countPotModifAAs(
  pepTab,
  modTy,
  maxMod = c(p = 3, h = 1, k = 1, o = 1, m = 1, n = 1, u = 1, r = 1, s = 1),
  specAAMod = NULL,
  knownMods = NULL,
  silent = FALSE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{pepTab}{(matrix) peptide sequences, start and end sites, typically result from \code{\link{makeFragments}}}

\item{modTy}{(list) modifications : $basMod for character vector of fixed modifications and $varMod for variable modifications. For one letter-code see AAfragSettings("modChem")}

\item{maxMod}{(integer) maximal number variable modifications will be considered in given fragment (may increase complexity and RAM consumption)}

\item{specAAMod}{(list) optional custom list showing which AA to be considered with which (one-letter) modification code (default \code{\link{AAfragSettings}})}

\item{knownMods}{(list) optional custom list showing which modification appears at what type of location, eg N-terminal, internal ... (default \code{\link{AAfragSettings}})}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}

\item{debug}{(logical) for bug-tracking: more/enhanced messages and intermediate objects written in global name-space}
}
\value{
list of matrixes $cou and $combTerm, with number of modifications per peptides (line in 'pepTab') for basMod, varMod & varMo2
}
\description{
Makes table 'cou' with counts of (potential) modification sites based on column 'seq' in matrix 'pepTab'.
Note: if multiple N-or C-term modifs, then only the first is shown in resulting table 'cou'.
}
\examples{
protP2 <- c(mesp="MESPEPTIDES", pepe="PEPEPEP")
pepTab1 <- makeFragments(protTab=protP2, minFra=6, internFr=TRUE, massTy="mono")
cou1 <- countPotModifAAs(pepTab=pepTab1, modTy=list(basMod=c("b","y"),
  varMod=c("p","h")), debug=FALSE)
modTy2 <- list(basMod=c("b","y","h"), varMod=c("x","p","o","q","e","j"))
cou2 <- countPotModifAAs(pepTab=pepTab1, modTy=modTy2)
}
\seealso{
\code{\link{AAfragSettings}}, \code{\link{makeFragments}}
}
