% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{cat_desc_table}
\alias{cat_desc_table}
\title{Compute absolute and relative frequencies for a table.}
\usage{
cat_desc_table(
  data,
  desc_vars,
  round_desc = 2,
  singleline = FALSE,
  spacer = " ",
  indentor = ""
)
}
\arguments{
\item{data}{name of data set (tibble/data.frame) to analyze.}

\item{desc_vars}{vector of column names for dependent variables.}

\item{round_desc}{number of significant digits for rounding of descriptive stats.}

\item{singleline}{Put all group levels in  a single line?}

\item{spacer}{Text element to indent levels and fill empty cells,
defaults to " ".}

\item{indentor}{Optional text to indent factor levels}
}
\value{
A tibble with variable names and descriptive statistics.
}
\description{
\code{cat_desc_table} computes absolute and relative frequencies for
categorical data with a number of formatting options.
}
\examples{
cat_desc_table(
  data = mtcars, desc_vars = c("gear", "cyl", "carb"))

cat_desc_table(
  data = mtcars, desc_vars = c("gear", "cyl", "carb"), singleline = TRUE)

}
