% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{pairwise_t_test}
\alias{pairwise_t_test}
\title{Extended pairwise t-test}
\usage{
pairwise_t_test(
  dep_var,
  indep_var,
  adjmethod = "fdr",
  plevel = 0.05,
  symbols = letters[-1]
)
}
\arguments{
\item{dep_var}{dependent variable, containing the data}

\item{indep_var}{independent variable, should be factor}

\item{adjmethod}{method for adjusting p values (see \link{p.adjust})}

\item{plevel}{threshold for significance}

\item{symbols}{predefined as b,c, d...;  provides footnotes to mark group
differences, e.g. b means different from group 2}
}
\value{
A list with method output of pairwise.t.test,
matrix of p-values, and character vector with significance indicators.
}
\description{
\code{pairwise_t_test}calculate pairwise comparisons between group levels
with corrections for multiple testing based on \link{pairwise.t.test}
}
\examples{
pairwise_t_test(dep_var = mtcars$wt, indep_var = mtcars$cyl)
}
