% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DebugFn.R
\name{buildNameCallback}
\alias{buildNameCallback}
\title{Build a custom writeback function that writes state into a user named variable.}
\usage{
buildNameCallback(varName)
}
\arguments{
\item{varName}{character where to write captured state}
}
\value{
writeback function for use with functions such as  \code{\link{DebugFnW}}
}
\description{
Build a custom writeback function that writes state into a user named variable.
}
\examples{

# user function
f <- function(i) { (1:10)[[i]] }
# capture last error in variable called "lastError"
writeBack <- buildNameCallback('lastError')
# wrap function with writeBack
df <- DebugFnW(writeBack,f)
# capture error (Note: tryCatch not needed for user code!)
tryCatch(
  df(12),
   error = function(e) { print(e) })
# examine error
str(lastError)
# redo call, perhaps debugging
tryCatch(
 do.call(lastError$fn_name, lastError$args),
   error = function(e) { print(e) })

}
