% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reduce.R
\name{reduceexpand}
\alias{reduceexpand}
\alias{\%|.\%}
\alias{\%.|\%}
\title{Use function to reduce or expand arguments.}
\usage{
f \%|.\% args

args \%.|\% f
}
\arguments{
\item{f}{function.}

\item{args}{argument list or vector, entries expanded as function arguments.}
}
\value{
f(args) where args elements become individual arguments of f.
}
\description{
\code{x \%.|\% f} stands for \code{f(x[[1]], x[[2]], ..., x[[length(x)]])}.
\code{v \%|.\% x} also stands for \code{f(x[[1]], x[[2]], ..., x[[length(x)]])}.
The two operators are the same, the variation just allowing the user to choose the order they write things.
The mnemonic is: "data goes on the dot-side of the operator."
}
\details{
Note: the reduce operation is implemented by \code{do.call()}, so has
standard R named argument semantics.
}
\section{Functions}{
\itemize{
\item \code{\%|.\%}: f reduce args

\item \code{\%.|\%}: args expand f
}}

\examples{

args <- list('prefix_', c(1:3), '_suffix')
args \%.|\% paste0
# prefix_1_suffix" "prefix_2_suffix" "prefix_3_suffix"
paste0 \%|.\% args
# prefix_1_suffix" "prefix_2_suffix" "prefix_3_suffix"

}
\seealso{
\code{\link[base]{do.call}}, \code{\link[base]{list}}, \code{\link[base]{c}}
}
