% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sample_me}
\alias{sample_me}
\title{Collapsed Gibbs sampler for hWRU. Internal function}
\usage{
sample_me(
  last_name,
  first_name,
  mid_name,
  geo,
  N_rg,
  pi_s,
  pi_f,
  pi_m,
  pi_nr,
  which_names,
  samples,
  burnin,
  race_init,
  verbose
)
}
\arguments{
\item{last_name}{Integer vector of last name identifiers for each record (zero indexed; as all that follow). Must match columns numbers in M_rs.}

\item{first_name}{See last_name}

\item{geo}{Integer vector of geographic units for each record. Must match column number in N_rg}

\item{N_rg}{Integer matrix of race | geography counts in census (geograpgies in columns).}

\item{pi_s}{Numeric matrix of race | surname prior probabilities.}

\item{pi_f}{Same as `pi_s`, but for first names.}

\item{pi_m}{Same as `pi_s`, but for middle names.}

\item{pi_nr}{Matrix of marginal probability distribution over missing names; non-keyword names default to this distribution.}

\item{which_names}{Integer; 0=surname only. 1=surname + first name. 2= surname, first, and middle names.}

\item{samples}{Integer number of samples to take after (in total)}

\item{burnin}{Integer number of samples to discard as burn-in of Markov chain}

\item{race_init}{Integer vector of initial race assignments}

\item{verbose}{Boolean; should informative messages be printed?}

\item{middle_name}{See last_name}

\item{M_rs}{Integer matrix of race | surname counts in dictionary (surnames in columns).}

\item{M_rf}{Same as `M_rs`, but for first names (can be empty matrix for surname only models).}

\item{M_rm}{Same as `M_rs`, but for middle names (can be empty matrix for surname, or surname and first name only models).}

\item{alpha}{Numeric matrix of race | geography prior probabilities.}

\item{me_race}{Boolean; should measurement error in race | geography be corrected?}
}
\description{
Collapsed Gibbs sampler for hWRU. Internal function
}
\keyword{internal}
