% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wt_methods.R
\name{wt_methods}
\alias{wt_methods}
\alias{summary.wt}
\alias{print.wt}
\alias{set_times.wt}
\alias{set_timescales.wt}
\alias{set_values.wt}
\alias{set_dat.wt}
\alias{set_wtopt.wt}
\alias{get_times.wt}
\alias{get_timescales.wt}
\alias{get_values.wt}
\alias{get_dat.wt}
\alias{get_wtopt.wt}
\title{Basic methods for the \code{wt} class}
\usage{
\method{summary}{wt}(object, ...)

\method{print}{wt}(x, ...)

\method{set_times}{wt}(obj, newval)

\method{set_timescales}{wt}(obj, newval)

\method{set_values}{wt}(obj, newval)

\method{set_dat}{wt}(obj, newval)

\method{set_wtopt}{wt}(obj, newval)

\method{get_times}{wt}(obj)

\method{get_timescales}{wt}(obj)

\method{get_values}{wt}(obj)

\method{get_dat}{wt}(obj)

\method{get_wtopt}{wt}(obj)
}
\arguments{
\item{object, x, obj}{An object of class \code{wt}}

\item{...}{Not currently used. Included for argument consistency
with existing generics.}

\item{newval}{A new value, for the \code{set_*} methods}
}
\value{
\code{summary.wt} produces a summary of a \code{wt} object.
A \code{print.wt} method is also available. For \code{wt} objects, 
\code{set_*} and \code{get_*} methods are available for all slots,
i.e., \code{*} equal to \code{times}, \code{timescales}, \code{wtopt}, 
\code{values}, and \code{dat}. The \code{set_*} methods just throw an 
error, to prevent breaking the consistency between the slots of a 
\code{wt} object.
}
\description{
Set, get, summary, and print methods for the \code{wt} class.
}
\examples{
time1<-1:100
time2<-101:200
ts1p1<-sin(2*pi*time1/15)
ts1p2<-0*time1
ts2p1<-0*time2
ts2p2<-sin(2*pi*time2/8)
ts1<-ts1p1+ts1p2
ts2<-ts2p1+ts2p2
ts<-c(ts1,ts2)
ra<-rnorm(200,mean=0,sd=0.5)
t.series<-ts+ra
t.series<-t.series-mean(t.series)
times<-c(time1,time2)
h<-wt(t.series, times)
get_times(h)
summary(h)
print(h)

}
\seealso{
\code{\link{wt}}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
