% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeSim.R
\name{writeSim}
\alias{writeSim}
\title{Write simulations to file}
\usage{
writeSim(wxOutput, nsim, nrealz, path = NULL, debug = FALSE)
}
\arguments{
\item{wxOutput}{Weather simulations output from `wx()` function.}

\item{nsim}{Number of simulation years.}

\item{nrealz}{Number of realizations (ensemble size).}

\item{path}{Specified path to where simulation output shall be written. Defaults to current working directory (path = NULL).
Specified path should be a character string of the folder location ending with '/'.}

\item{debug}{Option to include additional variables in the .csv file
outputs for debugging and advanced analysis. Includes sampling date, etc. Default = FALSE (off).
    If debug is off, the weather simulations will have a simulation year time stamp
    (beginning in year 1) as well as month and day time stamps.}
}
\value{
No return value, called to write simulation results to file.
}
\description{
Write simulation results to .csv files (one .csv file is generated for each trace).
Inputs include the weather simulations stored in the list object output from the `wx()` function as well as the `nsim` and `nrealz`
variables that were inputs to the `wx()` function.\cr
\cr
A debug flag allows for more detailed reports (debug = TRUE), but setting 'debug = FALSE' is generally
recommended for more concise output. Keeping 'debug = FALSE' will also include a simulation
time stamp (year, month, day) beginning in year 1.\cr
\cr
This function will write the .csv files to your working directory.\cr
\cr
Leap years may be included in the simulated weather if they are included in your training data,
so non-leap years include a row of 'NA' values at the end of the calendar year as a book-keeping
measure so that the total number of rows in each trace is the same.
}
\examples{

\donttest{
z = wx(trainingData = LowerSantaCruzRiverBasinAZ,
 eyr = 1990, nsim = 5, nrealz = 5, aseed = 23,
  wwidth = 3, unitSystem = "U.S. Customary",
   ekflag = TRUE, awinFlag = TRUE, tempPerturb = TRUE)


writeSim(wxOutput = z, nsim = 5, nrealz = 5, path = paste0(tempdir(), "/"), debug = FALSE)
}

}
