% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_logo.R
\name{css_position}
\alias{css_position}
\title{Helper to set absolute position of an element.}
\usage{
css_position(top = "1em", right = "1em", left = NULL, bottom = NULL)
}
\arguments{
\item{top, right, bottom, left}{The position of the element in distance from the
top, right, bottom, or left edge of it's container element.}
}
\value{
An object of class \code{css_position} that describes \code{top}, \code{right},
\code{bottom}, and \code{left} positions.
}
\description{
Sets position for an absolutely positioned element. Setting one of top or
bottom or one of left or right will "unset" the other. It's probably not a
good idea to set both top and bottom or right and left.
}
\examples{
css_position(top = "1em", right = "1em") # top right corner
css_position(top = "1em", left = "1em") # top left corner
css_position(bottom = 0, right = 0) # bottom right corner
}
