% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color.R
\name{choose_dark_or_light}
\alias{choose_dark_or_light}
\title{Choose dark or light color}
\usage{
choose_dark_or_light(x, black = "#000000", white = "#FFFFFF")
}
\arguments{
\item{x}{The background color (hex)}

\item{black}{Text or foreground color, e.g. "#222" or
\code{substitute(darken_color(x, 0.8))}, if black text provides the best contrast.}

\item{white}{Text or foreground color or expression, e.g. "#EEE" or
\code{substitute(lighten_color(x, 0.8))}, if white text provides the best contrast.}
}
\value{
The \code{black} color or \code{white} color according to which color provides
the greates contrast with the input color.
}
\description{
Takes a color input as \code{x} and returns either the black or white color (or
expression) if dark or light text should be used over the input color for
best contrast. Follows W3C Recommendations.
}
\examples{
light_green <- "#c4d6b0"
contrast_green <- choose_dark_or_light(light_green)
dark_purple <- "#381d2a"
contrast_purple <- choose_dark_or_light(dark_purple)

if (requireNamespace("scales", quietly = TRUE)) {
  scales::show_col(c(light_green, contrast_green, dark_purple, contrast_purple))
}

}
\references{
\url{https://stackoverflow.com/a/3943023/2022615}
}
