% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNF.R
\name{isTerminal}
\alias{isTerminal}
\title{Is the numeric identifier a terminal symbol?}
\usage{
isTerminal(Id, ST)
}
\arguments{
\item{Id}{A numeric identifier (integer).}

\item{ST}{A symbol table.}
}
\value{
\itemize{ 
   \item \code{TRUE} if the numeric identifier is a terminal symbol.
   \item \code{FALSE} if the numeric identifier is a non-terminal symbol.
   \item \code{NA} if the symbol does not exist.}
}
\description{
\code{isTerminal()} tests if the numeric identifier 
       is a terminal symbol.
}
\details{
\code{isTerminal()} is one of the most frequently used 
         functions of a grammar-based genetic programming algorithm.
         Careful coding pays off! 
         Do not index the symbol table as a matrix 
         (e.g. \code{ST[2,2]}), because this is really slow!
}
\examples{
g<-compileBNF(booleanGrammar())
isTerminal(1, g$ST)
isTerminal(2, g$ST)
isTerminal(5, g$ST)
isTerminal(12, g$ST)
isTerminal(15, g$ST)
identical(isTerminal(15, g$ST), NA)

}
\seealso{
Other Utility Functions: 
\code{\link{derive}()},
\code{\link{id2symb}()},
\code{\link{isNonTerminal}()},
\code{\link{rules}()},
\code{\link{symb2id}()}
}
\concept{Utility Functions}
