% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acceptance.R
\name{AcceptFactory}
\alias{AcceptFactory}
\title{Configure the acceptance function of a genetic algorithm.}
\usage{
AcceptFactory(method = "All")
}
\arguments{
\item{method}{A string specifying the acceptance rule.}
}
\value{
An acceptance rule for genes.
}
\description{
\code{AcceptanceFactory()} implements selection
             of an acceptance rule.

             Current support:

             \enumerate{
             \item "All" returns \code{AcceptNewGene()} (Default).
             \item "Best" returns \code{AcceptBest()}.
             \item "Metropolis" returns \code{AcceptMetropolis()}.
             \item "IVMetropolis" returns \code{AcceptIVMetropolis()}.
             }
}
\seealso{
Other Configuration: 
\code{\link{ApplyFactory}()},
\code{\link{CoolingFactory}()},
\code{\link{CrossRateFactory}()},
\code{\link{MutationRateFactory}()},
\code{\link{xegaConfiguration}()}
}
\concept{Configuration}
