% Generated by roxygen2 (4.0.1): do not edit by hand
\name{xgb.dump}
\alias{xgb.dump}
\title{Save xgboost model to text file}
\usage{
xgb.dump(model, fname, fmap = "")
}
\arguments{
\item{model}{the model object.}

\item{fname}{the name of the binary file.}

\item{fmap}{feature map file representing the type of feature.
       Detailed description could be found at
       \url{https://github.com/tqchen/xgboost/wiki/Binary-Classification#dump-model}.
       See demo/ for walkthrough example in R, and
       \url{https://github.com/tqchen/xgboost/blob/master/demo/data/featmap.txt}
       for example Format.}
}
\description{
Save a xgboost model to text file. Could be parsed later.
}
\examples{
data(agaricus.train, package='xgboost')
data(agaricus.test, package='xgboost')
train <- agaricus.train
test <- agaricus.test
bst <- xgboost(data = train$data, label = train$label, max.depth = 2,
               eta = 1, nround = 2,objective = "binary:logistic")
xgb.dump(bst, 'xgb.model.dump')
}

