% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_save_table.R
\name{xgx_save_table}
\alias{xgx_save_table}
\title{Saving table as an image, also labeling the program that created the table 
and where the table is stored}
\usage{
xgx_save_table(data, dirs = NULL, filename_main = NULL)
}
\arguments{
\item{data}{data.frame or table of results}

\item{dirs}{list of directories.  If NULL or if directories missing, there 
is default behavior below

\enumerate{
\item parent_dir  = Parent directory containing the Rscript and the 
Results folder, default getwd()
\item rscript_dir = Subdirectory of parent_dir that contains the Rscript 
used to generate the figure, default "./"
\item rscript_name= Name of the Rscript used to generate the figure, 
default "Name_Of_Script_Here.R"
\item results_dir = Subdirectory ofparent_dir where the figure is stored, 
default "./"
\item filename_prefix = prefix of filename to be appended to filename_main
}}

\item{filename_main}{main part of the filename, excluding prefix and 
extension.  no default}
}
\value{
ggplot2 plot object
}
\description{
Saving table as an image, also labeling the program that created the table 
and where the table is stored
}
\examples{
directory = tempdir()
dirs <- list(parent_dir  = directory,
             rscript_dir = directory,
             rscript_name = "example.R",
             results_dir = directory,
             filename_prefix = "example_")
data <- data.frame(x = c(1, 2), y = c(1, 2))
xgx_save_table(data, dirs = dirs, filename_main = "test")

}
