% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_list.R
\name{as_list}
\alias{as_list}
\title{Coerce xml nodes to a list.}
\usage{
as_list(x, ns = character(), ...)
}
\arguments{
\item{x}{A document, node, or node set.}

\item{ns}{Optionally, a named vector giving prefix-url pairs, as produced
by \code{\link{xml_ns}}. If provided, all names will be explicitly
qualified with the ns prefix, i.e. if the element \code{bar} is defined
in namespace \code{foo}, it will be called \code{foo:bar}. (And
similarly for atttributes). Default namespaces must be given an explicit
name.}

\item{...}{Needed for compatability with generic. Unused.}
}
\description{
This turns an XML document (or node or nodeset) into the equivalent R
list. Note that this is \code{as_list()}, not \code{as.list()}:
\code{lapply()} automatically calls \code{as.list()} on its inputs, so
we can't override the default.
}
\details{
\code{as_list} currently only handles the four most common types of
children that an element might have:

\itemize{
  \item Other elements, converted to lists.
  \item Attributes, stored as R attributes.
  \item Text, stored as a character vector.
}
}
\examples{
as_list(read_xml("<foo> a <b /><c><![CDATA[<d></d>]]></c></foo>"))
as_list(read_xml("<foo> <bar><baz /></bar> </foo>"))
as_list(read_xml("<foo id = 'a'></foo>"))
as_list(read_xml("<foo><bar id='a'/><bar id='b'/></foo>"))
}

