% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit_docinfo.R
\name{edit_docinfo}
\alias{edit_docinfo}
\alias{get_docinfo}
\alias{get_docinfo_pdftools}
\alias{get_docinfo_exiftool}
\alias{set_docinfo_exiftool}
\alias{get_docinfo_pdftk}
\alias{set_docinfo}
\alias{set_docinfo_gs}
\alias{set_docinfo_pdftk}
\title{Set/get pdf document info dictionary}
\usage{
get_docinfo(filename, use_names = TRUE)

get_docinfo_pdftools(filename, use_names = TRUE)

get_docinfo_exiftool(filename, use_names = TRUE)

set_docinfo_exiftool(docinfo, input, output = input)

get_docinfo_pdftk(filename, use_names = TRUE)

set_docinfo(docinfo, input, output = input)

set_docinfo_gs(docinfo, input, output = input)

set_docinfo_pdftk(docinfo, input, output = input)
}
\arguments{
\item{filename}{Filename(s) (pdf) to extract info dictionary entries from.}

\item{use_names}{If \code{TRUE} (default) use \code{filename} as the names of the result.}

\item{docinfo}{A "docinfo" object (as returned by \code{\link[=docinfo]{docinfo()}} or \code{\link[=get_docinfo]{get_docinfo()}}).}

\item{input}{Input pdf filename.}

\item{output}{Output pdf filename.}
}
\value{
\code{docinfo()} returns a "docinfo" R6 class.
\code{get_docinfo()} returns a list of "docinfo" R6 classes.
\code{set_docinfo()} returns the (output) filename invisibly.
}
\description{
\code{get_docinfo()} gets pdf document info from a file.
\code{set_docinfo()} sets pdf document info for a file.
}
\details{
\code{get_docinfo()} will try to use the following helper functions in the following order:
\enumerate{
\item \code{get_docinfo_pdftk()} which wraps \code{pdftk} command-line tool
\item \code{get_docinfo_exiftool()} which wraps \code{exiftool} command-line tool
\item \code{get_docinfo_pdftools()} which wraps \code{\link[pdftools:pdftools]{pdftools::pdf_info()}}
}

\code{set_docinfo()} will try to use the following helper functions in the following order:
\enumerate{
\item \code{set_docinfo_exiftool()} which wraps \code{exiftool} command-line tool
\item \code{set_docinfo_gs()} which wraps \code{ghostscript} command-line tool
\item \code{set_docinfo_pdftk()} which wraps \code{pdftk} command-line tool
}
}
\section{Known limitations}{

\itemize{
\item Currently does not support arbitrary info dictionary entries.
\item As a side effect \code{set_docinfo_gs()} seems to also update in previously set matching XPN metadata
while \code{set_docinfo_exiftool()} and \code{set_docinfo_pdftk()} don't update
any previously set matching XPN metadata.
Some pdf viewers will preferentially use the previously set document title from XPN metadata
if it exists instead of using the title set in documentation info dictionary entry.
Consider also manually setting this XPN metadata using \code{\link[=set_xmp]{set_xmp()}}.
\item Old metadata information is usually not deleted from the pdf file by these operations.
If deleting the old metadata is important one may want to try
\code{qpdf::pdf_compress(input, linearize = TRUE)}.
\item \code{get_docinfo_exiftool()} will "widen" datetimes to second precision.
\item \code{get_docinfo_pdftools()}'s datetimes may not accurately reflect the embedded datetimes.
\item \code{set_docinfo_pdftk()} may not correctly handle documentation info entries with newlines in them.
}
}

\examples{
if (supports_set_docinfo() && supports_get_docinfo() && require("grid", quietly = TRUE)) {
  f <- tempfile(fileext = ".pdf")
  pdf(f, onefile = TRUE)
  grid.text("Page 1")
  grid.newpage()
  grid.text("Page 2")
  invisible(dev.off())

  cat("\nInitial documentation info:\n\n")
  d <- get_docinfo(f)[[1]]
  print(d)

  d <- update(d,
              author = "John Doe",
              title = "Two Boring Pages",
              keywords = c("R", "xmpdf"))
  set_docinfo(d, f)

  cat("\nDocumentation info after setting it:\n\n")
  print(get_docinfo(f)[[1]])

  unlink(f)
}
}
\seealso{
\code{\link[=docinfo]{docinfo()}} for more information about the documentation info objects.  \code{\link[=supports_get_docinfo]{supports_get_docinfo()}}, \code{\link[=supports_set_docinfo]{supports_set_docinfo()}}, \code{\link[=supports_gs]{supports_gs()}}, and \code{\link[=supports_pdftk]{supports_pdftk()}} to detect support for these features. For more info about the pdf document info dictionary see
\url{https://opensource.adobe.com/dc-acrobat-sdk-docs/library/pdfmark/pdfmark_Basic.html#document-info-dictionary-docinfo}.
}
