% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{countxo}
\alias{countxo}
\title{Estimate number of crossovers}
\usage{
countxo(cross, chr = NULL)
}
\arguments{
\item{cross}{An object of class \code{cross}. (This must be a backcross.)
See \code{\link[qtl]{read.cross}} for details.}

\item{chr}{Optional set of chromosomes across which to count crossovers.  If
NULL, the total number of crossovers, genome-wide, is counted.}
}
\value{
A vector with the estimated number of crossovers for each
individual.
}
\description{
Estimate the number of crossovers in each meiosis in a backcross.
}
\details{
This works only a backcross.  We use the internal function (within R/qtl)
\code{locate.xo}.
}
\examples{

data(bssbsb)

# estimated number of crossovers on chr 1
nxo <- countxo(bssbsb, chr=1)

# estimated number of crossovers genome-wide
nxo <- countxo(bssbsb)

}
\seealso{
\code{\link{find.breaks}}
}
\author{
Karl W Broman, \email{kbroman@biostat.wisc.edu}
}
\keyword{utilities}
