% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_data.R
\name{data_opt}
\alias{data_opt}
\title{Create options for data import}
\usage{
data_opt(.problem = NULL, .subprob = NULL, .method = NULL,
  .source = "data", simtab = FALSE, filter = NULL, tidy = FALSE,
  index_col = NULL, value_col = NULL, post_processing = NULL)
}
\arguments{
\item{.problem}{The problem to be used, by default returns the last one.}

\item{.subprob}{The subproblem to be used, by default returns the last one.}

\item{.method}{The estimation method to be used, by default returns the last one.}

\item{.source}{Define the location of the data in the xpdb. Should be either 'data' 
to use the output tables or the name of an output file attached to the xpdb.}

\item{simtab}{Only used when 'data' is defined as the source and `.problem` is default. Should the data be coming 
from an estimation or a simulation table.}

\item{filter}{A function used to filter the data e.g. filter = function(x) x[x$TIME > 20, ] where x is the data.}

\item{tidy}{Logical, whether the data should be transformed to tidy data.}

\item{index_col}{Only used when 'tidy' is defined a \code{TRUE} and \code{value_col} is \code{NULL}. 
Column names to use as index when tidying the data.}

\item{value_col}{Only used when 'tidy' is defined a \code{TRUE} and \code{index_col} is \code{NULL}. 
Column names to be stacked when tidying the data.}

\item{post_processing}{A function used to modify the data after it has been tidied up e.g. post_processing = function(x) 
dplyr::mutate(.data = x, variable = as.factor(.$variable)) where x is the tidy data.}
}
\description{
Provide a list of options to the general plotting functions such as 
\code{xplot_scatter} in order to create appropriate data input for ggplot2.
}
\examples{
data_opt(.problem = 1, .source = 'data', simtab = TRUE)

}
\seealso{
\code{\link{xplot_distrib}} \code{\link{xplot_qq}} \code{\link{xplot_scatter}}
}
