% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranpar.vs.cov.R
\name{ranpar.vs.cov}
\alias{ranpar.vs.cov}
\title{Random parameters plotted against covariates, for Xpose 4}
\usage{
ranpar.vs.cov(object, onlyfirst = TRUE, smooth = TRUE, type = "p",
  main = "Default", ...)
}
\arguments{
\item{object}{An xpose.data object.}

\item{onlyfirst}{Logical value indicating whether only the first row per
individual is included in the plot.}

\item{smooth}{Logical value indicating whether an x-y smooth should be
superimposed.  The default is TRUE.}

\item{type}{The plot type - defaults to points only.}

\item{main}{The title of the plot.  If \code{"Default"} then a default title
is plotted. Otherwise the value should be a string like \code{"my title"} or
\code{NULL} for no plot title.}

\item{\dots}{Other arguments passed to \code{link{xpose.plot.default}}.}
}
\value{
Returns a stack of xyplots and histograms of random parameters
against covariates.
}
\description{
This creates a stack of plots of Bayesian random parameter estimates plotted
against covariates, and is a specific function in Xpose 4. It is a wrapper
encapsulating arguments to the \code{xpose.plot.default} function. Most of
the options take their default values from xpose.data object but may be
overridden by supplying them as arguments.
}
\details{
Each of the random parameters (ETAs) in the Xpose data object, as specified
in \code{object@Prefs@Xvardef$ranpar}, is plotted against each covariate
present, as specified in \code{object@Prefs@Xvardef$covariates}, creating a
stack of plots.

A wide array of extra options controlling \code{xyplots} are available. See
\code{\link{xpose.plot.default}} and \code{\link{xpose.panel.default}} for
details.
}
\examples{

\dontrun{
## We expect to find the required NONMEM run and table files for run
## 5 in the current working directory
xpdb <- xpose.data(5)

## A vanilla plot
ranpar.vs.cov(xpdb)

## Custom colours and symbols, IDs
ranpar.vs.cov(xpdb, cex=0.6, pch=3, col=1, ids=TRUE)
}

}
\seealso{
\code{\link{xpose.plot.default}},
\code{\link{xpose.plot.histogram}}, \code{\link[lattice]{xyplot}},
\code{\link[lattice]{histogram}}, \code{\link{xpose.prefs-class}},
\code{\link{xpose.data-class}}

Other specific functions: \code{\link{absval.cwres.vs.cov.bw}},
  \code{\link{absval.cwres.vs.pred.by.cov}},
  \code{\link{absval.cwres.vs.pred}},
  \code{\link{absval.iwres.cwres.vs.ipred.pred}},
  \code{\link{absval.iwres.vs.cov.bw}},
  \code{\link{absval.iwres.vs.idv}},
  \code{\link{absval.iwres.vs.ipred.by.cov}},
  \code{\link{absval.iwres.vs.ipred}},
  \code{\link{absval.iwres.vs.pred}},
  \code{\link{absval.wres.vs.cov.bw}},
  \code{\link{absval.wres.vs.idv}},
  \code{\link{absval.wres.vs.pred.by.cov}},
  \code{\link{absval.wres.vs.pred}},
  \code{\link{absval_delta_vs_cov_model_comp}},
  \code{\link{addit.gof}}, \code{\link{autocorr.cwres}},
  \code{\link{autocorr.iwres}},
  \code{\link{autocorr.wres}}, \code{\link{basic.gof}},
  \code{\link{basic.model.comp}},
  \code{\link{cat.dv.vs.idv.sb}}, \code{\link{cat.pc}},
  \code{\link{cov.splom}}, \code{\link{cwres.dist.hist}},
  \code{\link{cwres.dist.qq}}, \code{\link{cwres.vs.cov}},
  \code{\link{cwres.vs.idv.bw}},
  \code{\link{cwres.vs.idv}},
  \code{\link{cwres.vs.pred.bw}},
  \code{\link{cwres.vs.pred}},
  \code{\link{cwres_wres_vs_x}}, \code{\link{dOFV.vs.cov}},
  \code{\link{dOFV.vs.id}}, \code{\link{dOFV1.vs.dOFV2}},
  \code{\link{data.checkout}},
  \code{\link{dv.preds.vs.idv}}, \code{\link{dv.vs.idv}},
  \code{\link{dv.vs.ipred.by.cov}},
  \code{\link{dv.vs.ipred.by.idv}},
  \code{\link{dv.vs.ipred}},
  \code{\link{dv.vs.pred.by.cov}},
  \code{\link{dv.vs.pred.by.idv}},
  \code{\link{dv.vs.pred.ipred}}, \code{\link{dv.vs.pred}},
  \code{\link{gof}}, \code{\link{ind.plots.cwres.hist}},
  \code{\link{ind.plots.cwres.qq}},
  \code{\link{ind.plots}}, \code{\link{ipred.vs.idv}},
  \code{\link{iwres.dist.hist}},
  \code{\link{iwres.dist.qq}}, \code{\link{iwres.vs.idv}},
  \code{\link{kaplan.plot}}, \code{\link{par_cov_hist}},
  \code{\link{par_cov_qq}}, \code{\link{parm.vs.cov}},
  \code{\link{parm.vs.parm}}, \code{\link{pred.vs.idv}},
  \code{\link{runsum}}, \code{\link{wres.dist.hist}},
  \code{\link{wres.dist.qq}}, \code{\link{wres.vs.idv.bw}},
  \code{\link{wres.vs.idv}}, \code{\link{wres.vs.pred.bw}},
  \code{\link{wres.vs.pred}}, \code{\link{xpose.VPC.both}},
  \code{\link{xpose.VPC.categorical}},
  \code{\link{xpose.VPC}}, \code{\link{xpose4-package}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Andrew Hooker & Justin Wilkins
}
\keyword{methods}
