% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootgam.plots.R
\name{xp.boot.par.est.corr}
\alias{xp.boot.par.est.corr}
\title{Correlations between covariate coefficients}
\usage{
xp.boot.par.est.corr(bootgam.obj = NULL, sd.norm = TRUE,
  by.cov.type = FALSE, cov.plot = NULL, ask.covs = FALSE, dotpch = 19,
  col = rgb(0.2, 0.2, 0.9, 0.75), ...)
}
\arguments{
\item{bootgam.obj}{The object created using bootscm.import(), which hold the
data for plotting.}

\item{sd.norm}{Perform normalization of the covariate coefficients (default
is TRUE). When TRUE, the estimated covariate coefficients will be multiplied
by the standard deviation of the specific covariate (both for continuous and
categorical covariates).}

\item{by.cov.type}{Split the plot for continuous and dichotomous covariates.
Default is FALSE.}

\item{cov.plot}{A character vector which lists the covariates to include in
the plot. If none are specified (NULL), all covariate coefficients will be
included in the plot.}

\item{ask.covs}{Ask the user which covariates to include in the plot.
Default is FALSE.}

\item{dotpch}{The character used for plotting.}

\item{col}{The colors used for plotting.}

\item{\dots}{Additional plotting arguments may be passed to this function.}
}
\value{
No value returned.
}
\description{
This function creates a plot showing the correlations in estimates for
covariate coefficients, obtained from the first step (univariate testing) in
each scm performed in the bootscm.
}
\examples{

\dontrun{
xp.boot.par.est.corr(current.bootscm, sd.norm = TRUE,
                          cov.plot = c("CLSEX", "VSEX", "CLWT"))

}
}
\author{
Ron Keizer
}
\keyword{~bootscm}
