% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xseq_inference_learning.R
\name{InitXseqModel}
\alias{InitXseqModel}
\title{The datastructure to store the xseq models}
\usage{
InitXseqModel(mut, expr, net, expr.dis, prior, cpd, gene, p.h, weight,
  cis = FALSE, debug = FALSE)
}
\arguments{
\item{mut}{A data.frame of mutations. The data.frame should have
three columns of characters: sample, hgnc_symbol, and variant_type.
The variant_type column cat be either "HOMD", "HLAMP",
  "MISSENSE", "NONSENSE", "FRAMESHIFT", "INFRAME", "SPLICE", "NONSTOP",
  "STARTGAINED", "SYNONYMOUS", "OTHER", "FUSION", "COMPLEX".}

\item{expr}{A matrix of gene expression values where
each row corresponds to a patient and each column is a gene}

\item{net}{A list of gene interaction networks}

\item{expr.dis}{The fitted gene expression distributions,
output from \code{GetExpressionDistribution}}

\item{prior}{The prior for xseq, output from \code{SetXseqPrior}}

\item{cpd}{A list of conditional probability tables for xseq,
output from \code{SetXseqPrior}}

\item{gene}{A character vector of gene names,
default to all the genes with mutations}

\item{p.h}{The down-regulation probability list of each gene
connected to a mutated gene,
typically from running \code{LearnXseqParameter}
on a discovery dataset}

\item{weight}{The weight list of each gene
connected to a mutated gene,
typically from running \code{LearnXseqParameter}
on a discovery dataset}

\item{cis}{Logical, cis or trans analysis}

\item{debug}{Logical, whether to output debug information}
}
\value{
A xseq model
}
\description{
The datastructure to store the xseq models
}

