% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{decorations.data.frame}
\alias{decorations.data.frame}
\title{Retrieve Decorations for Data Frame}
\usage{
\method{decorations}{data.frame}(x, coerce = getOption("coerce", FALSE),
  ...)
}
\arguments{
\item{x}{data.frame}

\item{coerce}{logical whether to coerce factor levels to guide; alternatively, a key for the levels}

\item{...}{passed arguments}
}
\value{
named list
}
\description{
Retrieve the decorations of a data.frame; i.e., the metadata
used to decorate it. Returns a list with same names as the data.frame.
}
\examples{
library(csv)
file <- system.file(package = 'yamlet', 'extdata','yamlet.csv')
x <- decorate(as.csv(file))
decorations(x[,1:7])
decorations(decorate(as.csv(file), coerce = TRUE)[,1:7])
decorations(decorate(as.csv(file), coerce = TRUE)[,1:7], coerce = TRUE)
old <- getOption('coerce')
options(coerce = TRUE)
as.character(as_yamlet(decorate(as.csv(file))))
options(coerce = old)
}
\seealso{
Other decorate: \code{\link{decorate.character}},
  \code{\link{decorate.data.frame}},
  \code{\link{decorate.list}}, \code{\link{decorate}},
  \code{\link{decorations}}
}
\concept{decorate}
