% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_table.R
\name{io_table.data.frame}
\alias{io_table.data.frame}
\title{Export Documented Table}
\usage{
\method{io_table}{data.frame}(
  x,
  file = "",
  ext = getOption("yamlet_extension", ".yaml"),
  meta = stdout(),
  useBytes = FALSE,
  default_keys = getOption("yamlet_default_keys", list("label", "guide")),
  ...
)
}
\arguments{
\item{x}{data.frame}

\item{file}{passed to \code{\link{write.table}}}

\item{ext}{= extension for metadata equivalent of x}

\item{meta}{passed as \code{con} to \code{\link{io_yamlet}}}

\item{useBytes}{passed to \code{\link{io_yamlet}}}

\item{default_keys}{passed to \code{\link{io_yamlet}}}

\item{...}{passed to \code{\link{write.table}} (if accepted) and to \code{\link{io_yamlet}}}
}
\value{
invisible(file)
}
\description{
Exports a data.frame and a yamlet version of its decorations.
A wrapper for \code{\link{write.table}}.
}
\examples{
example(io_table)
}
\seealso{
Other io: 
\code{\link{io_csv}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table}()},
\code{\link{io_table.character}()},
\code{\link{io_yamlet}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{io_yamlet.yamlet}()}

Other interface: 
\code{\link{canonical.decorated}()},
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{enscript.default}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table.character}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.list}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}
}
\concept{interface}
\concept{io}
\keyword{internal}
