% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_csv.R
\name{io_csv}
\alias{io_csv}
\title{Import and Export Documented Tables as CSV}
\usage{
io_csv(x, ...)
}
\arguments{
\item{x}{object}

\item{...}{passed arguments}
}
\value{
See methods.
}
\description{
Imports or exports documented tables as comma-separated variable.
Generic, with methods that extend \code{\link[csv]{as.csv}}.
}
\examples{
# generate some decorated data
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(file)

# get a temporary filepath
out <- file.path(tempdir(), 'out.csv')

# save file using io_csv (returns filepath)
foo <- io_csv(x, out)
stopifnot(identical(out, foo))

# read using this filepath
y <- io_csv(foo)

# lossless round-trip (ignoring source attribute)
attr(x, 'source') <- NULL
attr(y, 'source') <- NULL
stopifnot(identical(x, y))
}
\seealso{
Other io: 
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{io_yamlet.yamlet}()}
}
\concept{io}
