% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnn.predict.R
\name{pnn.predict}
\alias{pnn.predict}
\title{Calculate a matrix of predicted probabilities}
\usage{
pnn.predict(net, x)
}
\arguments{
\item{net}{The PNN object generated by pnn.fit()}

\item{x}{The matrix of input predictors}
}
\value{
A matrix of predicted probabilities for all categories
}
\description{
The function \code{pnn.predict} calculates a matrix of predicted probabilities based on a matrix of predictors
}
\examples{
data(iris, package = "datasets")
Y <- iris[, 5]
X <- scale(iris[, 1:4])
pnet <- pnn.fit(x = X, y = Y)
pnn.predict(pnet, X[seq(5), ])
}
\seealso{
\code{\link{pnn.predone}}
}
